/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.util.Stack;

class SpacePanel
extends Panel {
    public boolean anaglyphic = false;
    private PhysicsEngine engine = null;
    double rotation;
    double anaglyphDepth = 0.1;
    double drawingScale = 1.0E-12;
    double sinVal;
    double cosVal;
    double oldAngle = 1.0E30;
    SpaceApplet parent;
    boolean busy = false;
    Stack undrawData;
    Image image = null;
    Dimension old_size = null;

    SpacePanel(SpaceApplet spaceApplet) {
        this.parent = spaceApplet;
        this.rotation = 20.0 * this.parent.toRad;
        this.engine = new PhysicsEngine(this.parent);
        this.setBackground(Color.black);
        this.undrawData = new Stack();
    }

    public void testRepaint() {
        if (!this.busy) {
            this.busy = true;
            this.repaint();
            this.getToolkit().sync();
            this.busy = false;
        } else {
            System.out.println("skipped frame");
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Graphics graphics2;
        double d = this.parent.timeStepHours * 3600.0;
        Dimension dimension = this.getSize();
        if (this.image == null || this.old_size == null || !this.old_size.equals(dimension)) {
            this.image = this.createImage(dimension.width, dimension.height);
            graphics2 = this.image.getGraphics();
            graphics2.setColor(Color.black);
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            this.old_size = dimension;
        }
        graphics2 = this.image.getGraphics();
        this.drawObjects(d, graphics2, dimension);
        graphics.drawImage(this.image, 0, 0, this);
    }

    private void drawObjects(double d, Graphics graphics, Dimension dimension) {
        double d2 = dimension.width / 2;
        double d3 = dimension.height / 2;
        int n = (int)(d2 / 96.0);
        n = n < 4 ? 4 : n;
        this.undrawAll(graphics, n);
        graphics.setColor(Color.white);
        this.drawOval(graphics, (int)d2, (int)d3, n * 2);
        if (this.anaglyphic) {
            graphics.setXORMode(Color.white);
        } else {
            graphics.setPaintMode();
        }
        if (this.parent.planetCheckBox.isSelected()) {
            this.drawSubset(1, d, d2, d3, n, graphics, dimension, this.parent.orbitData.planet_array);
        }
        if (this.parent.cometCheckBox.isSelected()) {
            this.drawSubset(0, d, d2, d3, n, graphics, dimension, this.parent.orbitData.comet_array);
        }
    }

    private void drawSubset(int n, double d, double d2, double d3, int n2, Graphics graphics, Dimension dimension, OrbitingBody[] orbitingBodyArray) {
        this.engine.processObjects(orbitingBodyArray, d);
        for (int i = n; i < orbitingBodyArray.length; ++i) {
            OrbitingBody orbitingBody = orbitingBodyArray[i];
            Cart3 cart3 = this.scaleOrbitingBody(orbitingBody, d2, d3, this.rotation);
            if (!this.anaglyphic) {
                graphics.setColor(orbitingBody.color);
                this.drawOval(graphics, (int)cart3.x, (int)cart3.y, n2);
                continue;
            }
            int n3 = (int)(cart3.x + cart3.z * this.anaglyphDepth);
            int n4 = (int)(cart3.x - cart3.z * this.anaglyphDepth);
            graphics.setColor(Color.cyan);
            this.drawOval(graphics, n3, (int)cart3.y, n2);
            graphics.setColor(Color.red);
            this.drawOval(graphics, n4, (int)cart3.y, n2);
        }
    }

    private void drawOval(Graphics graphics, int n, int n2, int n3) {
        Point point = new Point(n, n2);
        this.undrawData.push(point);
        graphics.fillOval(n, n2, n3, n3);
    }

    private void undrawAll(Graphics graphics, int n) {
        graphics.setPaintMode();
        graphics.setColor(Color.black);
        while (!this.undrawData.empty()) {
            Point point = (Point)this.undrawData.pop();
            graphics.fillOval(point.x, point.y, n, n);
        }
    }

    private Cart3 scaleOrbitingBody(OrbitingBody orbitingBody, double d, double d2, double d3) {
        Cart3 cart3 = new Cart3();
        cart3.x = orbitingBody.pos.x * this.drawingScale * d + d;
        if (d3 != this.oldAngle) {
            this.sinVal = Math.sin(d3);
            this.cosVal = Math.cos(d3);
            this.oldAngle = d3;
        }
        double d4 = orbitingBody.pos.z * this.sinVal + orbitingBody.pos.y * this.cosVal;
        double d5 = orbitingBody.pos.z * this.cosVal + orbitingBody.pos.y * this.sinVal;
        cart3.y = d4 * this.drawingScale * d2 + d2;
        cart3.z = d5 * this.drawingScale * d2;
        return cart3;
    }

    public void toggleAnaglyphic() {
        this.anaglyphic = !this.anaglyphic;
        this.testRepaint();
    }
}

