/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SpaceApplet
extends Applet
implements Runnable {
    private boolean m_fStandAlone = false;
    int defaultWidth = 640;
    int defaultHeight = 480;
    public String appName = "Space Applet 1.5";
    public String copyright = "Copyright (C) 2013, Paul Lutus, released under the GPL";
    private Thread m_space = null;
    private int repaintMs = 5;
    public int cometCount = 16;
    public double darkEnergy;
    public double timeStepHours;
    public boolean darkEnergyMode = false;
    private boolean running = true;
    double toRad = Math.PI / 180;
    private SpacePanel spacePanel;
    public OrbitingData orbitData;
    private JCheckBox anaglyphCheckbox;
    private JPanel bodyControlPanel;
    public JCheckBox cometCheckBox;
    private JTextField cometsTextField;
    private JPanel controlPanel;
    private JCheckBox darkEnergyCheckBox;
    private JTextField darkEnergyTextField;
    private JPanel defaultPanel;
    private JLabel jLabel1;
    private JButton launchButton;
    public JCheckBox planetCheckBox;
    private JButton resetButton;
    private JCheckBox runStopCheckbox;
    private JTextField timeStepTextField;

    public static void main(String[] stringArray) {
        SpaceApplet spaceApplet = new SpaceApplet();
        GenericFrame genericFrame = new GenericFrame(spaceApplet.appName);
        genericFrame.setSize(genericFrame.getInsets().left + genericFrame.getInsets().right + spaceApplet.defaultWidth, genericFrame.getInsets().top + genericFrame.getInsets().bottom + spaceApplet.defaultHeight);
        genericFrame.add("Center", spaceApplet);
        spaceApplet.m_fStandAlone = true;
        spaceApplet.init();
        spaceApplet.start();
        genericFrame.setVisible(true);
    }

    public void init() {
        this.initComponents();
        this.orbitData = new OrbitingData(this);
        this.spacePanel = new SpacePanel(this);
        this.add((Component)this.spacePanel, "Center");
        if (this.m_fStandAlone) {
            this.bodyControlPanel.remove(this.launchButton);
        }
        this.setup();
    }

    private void launchInFrame() {
        if (!this.m_fStandAlone) {
            this.runStopCheckbox.setSelected(false);
            this.stop();
            SpaceApplet.main(new String[2]);
        }
    }

    private void setup() {
        this.stop();
        this.orbitData.setup();
        this.setTimeStep();
        this.setCometCount();
        this.setDarkEnergy();
        this.startStop();
    }

    private void setTimeStep() {
        this.timeStepHours = 1.0;
        try {
            this.timeStepHours = Double.parseDouble(this.timeStepTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeStepHours = this.timeStepHours < 1.0 ? 1.0 : this.timeStepHours;
    }

    private void setDarkEnergy() {
        this.darkEnergy = 0.0;
        this.darkEnergyMode = this.darkEnergyCheckBox.isSelected();
        try {
            this.darkEnergy = Double.parseDouble(this.darkEnergyTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAnaglyphMode() {
        this.spacePanel.anaglyphic = this.anaglyphCheckbox.isSelected();
    }

    private void setCometCount() {
        this.cometCount = 16;
        try {
            this.cometCount = Integer.parseInt(this.cometsTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cometCount = this.cometCount < 1 ? 1 : this.cometCount;
        this.orbitData.readComets(this.cometCount);
    }

    private void startStop() {
        if (this.runStopCheckbox.isSelected()) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void start() {
        if (this.m_space == null) {
            this.m_space = new Thread(this);
            this.running = true;
            this.m_space.start();
        }
    }

    public void stop() {
        if (this.m_space != null) {
            this.running = false;
            while (this.m_space.isAlive()) {
            }
            this.m_space = null;
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.isVisible()) {
                    this.spacePanel.repaint();
                    this.getToolkit().sync();
                    Thread.sleep(this.repaintMs);
                    continue;
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                this.stop();
            }
        }
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.defaultPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.timeStepTextField = new JTextField();
        this.runStopCheckbox = new JCheckBox();
        this.anaglyphCheckbox = new JCheckBox();
        this.resetButton = new JButton();
        this.bodyControlPanel = new JPanel();
        this.planetCheckBox = new JCheckBox();
        this.cometCheckBox = new JCheckBox();
        this.cometsTextField = new JTextField();
        this.darkEnergyCheckBox = new JCheckBox();
        this.darkEnergyTextField = new JTextField();
        this.launchButton = new JButton();
        this.setLayout(new BorderLayout());
        this.controlPanel.setBackground(new Color(255, 255, 204));
        this.controlPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.controlPanel.setLayout(new BorderLayout());
        this.defaultPanel.setBackground(new Color(255, 255, 204));
        this.jLabel1.setText("Time Step (hours)");
        this.defaultPanel.add(this.jLabel1);
        this.timeStepTextField.setHorizontalAlignment(4);
        this.timeStepTextField.setText("64");
        this.timeStepTextField.setMinimumSize(new Dimension(30, 19));
        this.timeStepTextField.setPreferredSize(new Dimension(60, 19));
        this.timeStepTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SpaceApplet.this.timeStepTextFieldKeyReleased(keyEvent);
            }
        });
        this.defaultPanel.add(this.timeStepTextField);
        this.runStopCheckbox.setBackground(new Color(255, 255, 204));
        this.runStopCheckbox.setSelected(true);
        this.runStopCheckbox.setText("Run/Stop");
        this.runStopCheckbox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpaceApplet.this.runStopCheckboxMouseClicked(mouseEvent);
            }
        });
        this.defaultPanel.add(this.runStopCheckbox);
        this.anaglyphCheckbox.setBackground(new Color(255, 255, 204));
        this.anaglyphCheckbox.setText("Anaglyphic");
        this.anaglyphCheckbox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpaceApplet.this.anaglyphCheckboxMouseClicked(mouseEvent);
            }
        });
        this.defaultPanel.add(this.anaglyphCheckbox);
        this.resetButton.setBackground(new Color(255, 255, 204));
        this.resetButton.setText("Reset");
        this.resetButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpaceApplet.this.resetButtonMouseClicked(mouseEvent);
            }
        });
        this.defaultPanel.add(this.resetButton);
        this.controlPanel.add((Component)this.defaultPanel, "Center");
        this.bodyControlPanel.setBackground(new Color(255, 255, 204));
        this.planetCheckBox.setBackground(new Color(255, 255, 204));
        this.planetCheckBox.setSelected(true);
        this.planetCheckBox.setText("Planets");
        this.bodyControlPanel.add(this.planetCheckBox);
        this.cometCheckBox.setBackground(new Color(255, 255, 204));
        this.cometCheckBox.setSelected(true);
        this.cometCheckBox.setText("Comets");
        this.bodyControlPanel.add(this.cometCheckBox);
        this.cometsTextField.setHorizontalAlignment(4);
        this.cometsTextField.setText("32");
        this.cometsTextField.setPreferredSize(new Dimension(60, 19));
        this.cometsTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SpaceApplet.this.cometsTextFieldKeyReleased(keyEvent);
            }
        });
        this.bodyControlPanel.add(this.cometsTextField);
        this.darkEnergyCheckBox.setBackground(new Color(255, 255, 204));
        this.darkEnergyCheckBox.setText("Dark Energy");
        this.darkEnergyCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpaceApplet.this.darkEnergyCheckBoxMouseClicked(mouseEvent);
            }
        });
        this.bodyControlPanel.add(this.darkEnergyCheckBox);
        this.darkEnergyTextField.setHorizontalAlignment(4);
        this.darkEnergyTextField.setText("4e-15");
        this.darkEnergyTextField.setPreferredSize(new Dimension(60, 19));
        this.darkEnergyTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SpaceApplet.this.darkEnergyTextFieldKeyReleased(keyEvent);
            }
        });
        this.bodyControlPanel.add(this.darkEnergyTextField);
        this.launchButton.setBackground(new Color(255, 255, 204));
        this.launchButton.setText("Separate");
        this.launchButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpaceApplet.this.launchButtonMouseClicked(mouseEvent);
            }
        });
        this.bodyControlPanel.add(this.launchButton);
        this.controlPanel.add((Component)this.bodyControlPanel, "South");
        this.add((Component)this.controlPanel, "South");
    }

    private void launchButtonMouseClicked(MouseEvent mouseEvent) {
        this.launchInFrame();
    }

    private void timeStepTextFieldKeyReleased(KeyEvent keyEvent) {
        this.setTimeStep();
    }

    private void cometsTextFieldKeyReleased(KeyEvent keyEvent) {
        this.setCometCount();
    }

    private void darkEnergyTextFieldKeyReleased(KeyEvent keyEvent) {
        this.setDarkEnergy();
    }

    private void darkEnergyCheckBoxMouseClicked(MouseEvent mouseEvent) {
        this.setDarkEnergy();
    }

    private void resetButtonMouseClicked(MouseEvent mouseEvent) {
        this.setup();
    }

    private void anaglyphCheckboxMouseClicked(MouseEvent mouseEvent) {
        this.setAnaglyphMode();
    }

    private void runStopCheckboxMouseClicked(MouseEvent mouseEvent) {
        this.startStop();
    }
}

