/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

class OrbitingData {
    SpaceApplet parent;
    public OrbitingBody[] planet_array = null;
    public OrbitingBody[] comet_array = null;
    public Color[] planet_colors = new Color[]{Color.white, Color.yellow, Color.cyan, new Color(128, 128, 255), Color.red, Color.green, Color.magenta, Color.blue};
    String data = "Name,OrbitRad,BodyRad,Mass,OrbitVel\nSun,0,695000000,1.989E+030,0\nMercury,57900000000,2440000,3.33E+023,47900\nVenus,108000000000,6050000,4.869E+024,35000\nEarth,150000000000,6378140,5.976E+024,29800\nMars,227940000000,3397200,6.421E+023,24100\nJupiter,778330000000,71492000,1.9E+027,13100\nSaturn,1429400000000,60268000,5.688E+026,9640\nUranus,2870990000000,25559000,8.686E+025,6810\nNeptune,4504300000000,24746000,1.024E+026,5430\nPluto,5913520000000,1137000,1.27E+022,4740\n";

    OrbitingData(SpaceApplet spaceApplet) {
        this.parent = spaceApplet;
        this.setup();
    }

    public void setup() {
        this.readOrbitingBodies();
        this.readComets(this.parent.cometCount);
    }

    private void readOrbitingBodies() {
        ArrayList<OrbitingBody> arrayList = new ArrayList<OrbitingBody>();
        String[] stringArray = this.data.split("\n");
        double[] dArray = new double[4];
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            for (int j = 1; j < stringArray2.length; ++j) {
                dArray[j - 1] = Double.parseDouble(stringArray2[j]);
            }
            Cart3 cart3 = new Cart3(-dArray[0], 0.0, 0.0);
            Cart3 cart32 = new Cart3(0.0, 0.0, dArray[3]);
            Color color = this.planet_colors[(i - 1) % this.planet_colors.length];
            OrbitingBody orbitingBody = new OrbitingBody(stringArray2[0], dArray[1], cart3, cart32, dArray[2], color);
            arrayList.add(orbitingBody);
        }
        this.planet_array = arrayList.toArray(new OrbitingBody[arrayList.size()]);
    }

    public void readComets(int n) {
        ArrayList<OrbitingBody> arrayList = new ArrayList<OrbitingBody>();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            String string = "comet" + i;
            double d = random.nextDouble() * 360.0;
            double d2 = random.nextDouble() * 100000.0 + 100000.0;
            Cart3 cart3 = new Cart3((d2 *= 4000000.0) * Math.sin(d * this.parent.toRad), 0.0, d2 * Math.cos(d * this.parent.toRad));
            double d3 = (random.nextDouble() * 200.0 + 100.0) * 50.0;
            d3 = i % 2 == 1 ? -d3 : d3;
            Cart3 cart32 = new Cart3(0.0, d3, 0.0);
            Color color = this.planet_colors[i % this.planet_colors.length];
            OrbitingBody orbitingBody = new OrbitingBody(string, 1000.0, cart3, cart32, 1.0E9, color);
            arrayList.add(orbitingBody);
        }
        this.comet_array = arrayList.toArray(new OrbitingBody[arrayList.size()]);
    }
}

